#include "allegro.h"

#ifdef _WIN32
#include "winalleg.h"

#include <winsock.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#endif

#include "client.h"
#include "defs.h"
#include "engine.h"
#include "console.h"
#include "gfx.h"
#include "items.h"
#include "network.h"
#include "packet.h"
#include "player.h"
#include "rules.h"
#include "server.h"
#include "sound.h"
#include "weapons.h"

void gameViewport::draw()
{
   clear_bitmap(sniping);

   set_clip_rect(leftpane, 0, 0, paneSizeX - 1, paneSizeY - 1);
   
   TRACE(" -- draw\n");
   TRACE("    level\n");
   drawLevel();
   TRACE("    items\n");
   ItemsDraw();
   TRACE("    lines\n");
   drawLines();
   TRACE("    worms\n");
   drawWorms();
   TRACE("    specials\n");
   drawSpecials();
   TRACE("    weaps\n");
   drawWeaps();
   TRACE("    shrap\n");
   drawShrap();
   TRACE("    sightlines\n");
   drawSightLines();
   TRACE("    wps\n");
   drawWPs();

   TRACE("    lights\n");
   drawLights();

   TRACE("    crosshair\n");
   drawCrosshair();

   set_clip_rect(leftpane, 0, 0, leftpane->w - 1, leftpane->h - 1);

   TRACE("    hud\n");
   drawHud();

   TRACE("    radar\n");
   drawRadar();
};
