//include <libnet.h>
#include "allegro.h"
#include <stdlib.h>

#ifdef _WIN32
#include "winalleg.h"
#include <windows.h>
#include <winsock.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#define FAR 
#define SOCKET_ERROR -1
#endif

#include "defs.h"
#include "console.h"
#include "network.h"

int NetworkInit() {
#ifdef _WIN32
	
	WSADATA wsadata;

    Console.WriteF("Initializing Winsock...");
	return WSAStartup (MAKEWORD (2, 2), &wsadata);
#else
    return 0;
#endif
}

void NetSetNoDelay (SOCKET s)
{
	char no_delay = 1;

	setsockopt (s, IPPROTO_TCP, TCP_NODELAY, (const char FAR *) &no_delay, sizeof (no_delay));
}

void NetShutdown (void)
{
#ifdef _WIN32
	WSACleanup ();
#endif
}

int NetSendTcpPacket (SOCKET s, unsigned char *data, int size)
{
	int write_len;
	char *ptr;

	ptr = (char *)data;
	do {
		write_len = send (s, (char *)data, (size-(ptr-((char *)data))), 0);
		if (write_len == SOCKET_ERROR)
			return -1;
		ptr += write_len;
    }
    while (ptr != (((char *) data)+size));

	return 0;
}

void net_send_rdm(SOCKET s, unsigned char *data, int len)
{
   NetSendTcpPacket (s, data, len);
}

