#include "allegro.h"

#ifdef _WIN32
#include "winalleg.h"
#include <winsock.h>
#else
#endif

#include "client.h"
#include "defs.h"
#include "console.h"
#include "ai.h"
#include "engine.h"
#include "items.h"
#include "netio.h"
#include "network.h"
#include "packet.h"
#include "player.h"
#include "rules.h"
#include "server.h"
#include "sound.h"

#include "demos.h"

void netReceiveKeys()
{
   int i;
   unsigned char tmp;

   for (i=0; i<GP_NUM_PLAYERS; i++)
   {
      tmp = bufor[i];
      
      if (gameOver) tmp = 0;
      
      worms[i].buttons[GK_JUMP] = ((tmp & KP_JUMP) == KP_JUMP);
      worms[i].buttons[GK_FIRE] = ((tmp & KP_FIRE) == KP_FIRE);
      worms[i].buttons[GK_CHANGE] = ((tmp & KP_CHANGE) == KP_CHANGE);
      worms[i].buttons[GK_LEFT] = ((tmp & KP_LEFT) == KP_LEFT);
      worms[i].buttons[GK_RIGHT] = ((tmp & KP_RIGHT) == KP_RIGHT);
      worms[i].buttons[GK_UP] = ((tmp & KP_UP) == KP_UP);
      worms[i].buttons[GK_DOWN] = ((tmp & KP_DOWN) == KP_DOWN);
   }
      
}

void netSendKeys()
{
   int numPlayaz = numPlayers;
   poll_joystick();

   for (int i = 0; i < numPlayaz; i++)
   {
      unsigned char tmp = 0;

      if (!chatActive)
      {
         if (players[i].useJoy > 0)
         {
            if (joy[players[i].useJoy-1].button[players[i].joybtns[GK_JUMP]].b) tmp += KP_JUMP;
            if (joy[players[i].useJoy-1].button[players[i].joybtns[GK_FIRE]].b) tmp += KP_FIRE;
            if (joy[players[i].useJoy-1].button[players[i].joybtns[GK_CHANGE]].b) tmp += KP_CHANGE;
            if (joy[players[i].useJoy-1].stick[0].axis[0].pos < -64) tmp += KP_LEFT;
            if (joy[players[i].useJoy-1].stick[0].axis[0].pos > 64) tmp += KP_RIGHT;
            if (joy[players[i].useJoy-1].stick[0].axis[1].pos < -64) tmp += KP_UP;
            if (joy[players[i].useJoy-1].stick[0].axis[1].pos > 64) tmp += KP_DOWN;
         }
         else
         {
            if (key[players[i].keys[GK_JUMP]]) tmp += KP_JUMP;
            if (key[players[i].keys[GK_FIRE]]) tmp += KP_FIRE;
            if (key[players[i].keys[GK_CHANGE]]) tmp += KP_CHANGE;
            if (key[players[i].keys[GK_LEFT]]) tmp += KP_LEFT;
            if (key[players[i].keys[GK_RIGHT]]) tmp += KP_RIGHT;
            if (key[players[i].keys[GK_UP]]) tmp += KP_UP;
            if (key[players[i].keys[GK_DOWN]]) tmp += KP_DOWN;
         }
      }
   
      if (!isServer)
      {
         Packet(CLIENT_MOVE);
         PacketAddByte(tmp);
         Client.SendPacket(packetsend, CLIENT_MOVE_SIZE, 1);
      }
      else
      {
         bufor[i] = tmp;
         worms[i].sentKeys = 1;
      }
   }
}

void networkServerListen()
{
	/* Check for connecting clients. */
    if (!gameStart)
	if (ServerListen() == 0) {
		/* A client just connected, now send back the current game data. */

		/* Send players. */
		int n, i;
		for(n = 0; n < GP_MAX_PLAYERS; n++) {
			if(worms[n].active) {

				Packet(PACKET_JOIN);
				PacketAddByte(n);
				PacketAddByte(worms[n].team);
				PacketAddByte(worms[n].skin);
                for (i=0; i<21; i++)
                {
                    PacketAddByte(worms[n].name[i]);
                }
				/* Send it to the client who just joined. */
				ServerSendTo(packetsend, PACKET_JOIN_SIZE, ClientNum);
			}
		}
  
        /* Send weapons. */
		for(n = 0; n < GP_MAX_PLAYERS; n++) {

			if(worms[n].active) {
       			Packet(PACKET_WEAP);
       			PacketAddByte(n);
                for (i=0; i < 5; i++)
                {
                    PacketAddByte(worms[n].weaps[i]);
                }
      			ServerSendTo(packetsend, PACKET_WEAP_SIZE, ClientNum);
            }
        }

		Packet(PACKET_MAPN);

		for (n = 0; n < 21; n++)
		{
			PacketAddByte(mapName[n]);
		}
		ServerSendTo(packetsend, PACKET_MAPN_SIZE, ClientNum);

        TheGamePacket();
        Console.WriteF("Sending %d, %d", packetsend[7], packetsend[8]);
		ServerSendTo(packetsend, PACKET_GAME_SIZE, ClientNum);

	}
}

void networkServerProcess()
{
	int i, packetId;

 	/* Check for game start. */

    if((key[KEY_F1]) && (!gameStart) && (!isDedicated)) {
        gameStart = 1;

		Packet(PACKET_STRT);
		ServerBroadcast(packetsend, PACKET_STRT_SIZE);
    }

	/* Check for network packets. */

    for (i=0; i<GP_MAX_PLAYERS; i++)
    if ((!gameStart) || (worms[i].active))
    {
        if (ClientConn[i] != -2)
        if (ClientConn[i] != -1)
        {
            if ((packetId = serverGetMessageId(ClientConn[i])) != -1)
            {
                serverProcessMessage(i, packetId);
            }
        }
    }
    if (gameStart)
    {
       	char sendIt = 1;
        if (!asyncServer)
        {
            for(i = 0; i < GP_NUM_PLAYERS; i++)
            {   
                if (worms[i].isAi)
                if (!worms[i].sentKeys)
                {
                   aiProcess(&worms[i]);
                }
            }
            for(i = 0; i < GP_NUM_PLAYERS; i++)
            {   
                if ((worms[i].active) && (!worms[i].sentKeys))
                {
	                sendIt = 0;
                    break;
                }
            }
		  }

        if (sendIt)
        {
            gotKeys = 1;
		    Packet(PACKET_MOVE);
		    for(i = 0; i < GP_NUM_PLAYERS; i++)
		    {
			    PacketAddByte(bufor[i]);
			    worms[i].sentKeys = 0;
		    }
		    ServerBroadcast(packetsend, PACKET_MOVE_SIZE);
	    }
    }
}

void networkProcess()
{
   int packetId;

   if ((packetId = Client.GetMessageID()) != -1)
   {
      Client.ProcessMessage(packetId);
   }
}

