#include "defs.h"
#include "ai.h"
#include "engine.h"
#include "gfx.h"
#include "items.h"
#include "sound.h"
#include "weapons.h"

void weapPack::collision(worm *player)
{
   if (this->owner)
      return; // has been picked up
   player->weaps[player->curWeap] = this->amount;
   this->owner = player;
   this->localTime = gameTime;
   player->next_fire[player->curWeap] = gameTime;
   player->ammo[player->curWeap] = weapons[this->amount].maxAmmo;
   Sound.playSound(medKitPickup, this->CurX, this->CurY);
};

void weapPack::throwWeap(worm *player)
{
   for (int i = 0; i < weapons[this->amount].numObjects * weapons[this->amount].maxAmmo; i++)
   {
      char dir = abs(RANDOM())%2;
      int angle = abs(RANDOM())%33;
      long speed = weapons[this->amount].initSpeed + (abs(RANDOM()) * weapons[this->amount].speedVariation)/1000;
      long vx = (speed * cosinus[angle]) / 1000;
      long vy = (speed * sinus[angle]) / 1000;
      if (dir) vx = -vx;
      spawnWeaponObject(this->x, this->y, owner, this->amount, vx, vy);
   }
};

void weapPack::blow(worm *player)
{
   if (this->owner)
      return; // has been picked up
   this->owner = player;
   this->localTime = gameTime;
   createSpecial(this->owner, this->CurX, this->CurY, itemExplosion, &weapons[this->owner->weaps[this->owner->curWeap]], &always1);
// fire 'em up!
   if (abs(RANDOM()) < Engine.items.fireProbability)
      this->throwWeap(this->owner);
};

void weapPack::draw(gameViewport *where)
{
   BITMAP *tempWeap;
   
   if (this->owner)
      return; // has been picked up
   tempWeap = create_sub_bitmap(imgWeap, Engine.items.weappackSprite*7, 0, 7, 7);
   draw_sprite(where->leftpane, tempWeap, this->CurX - where->CurX - 3, this->CurY - where->CurY - 3);
   if (Engine.items.drawNamesOnBonuses)
      drawTextCenter(where->leftpane, weapons[this->amount].name, this->CurX - where->CurX, this->CurY - where->CurY - 10);
   draw_sprite(where->sniping, tempWeap, this->CurX - where->SnipX - 3, this->CurY - where->SnipY - 3);
   destroy_bitmap(tempWeap);
};

void weapPack::think()
{
   if (!this->owner)
      return; // not picked up
   if (gameTime - this->localTime >= this->respawn)
   {
      if (Engine.crateDrops)
      {
         this->amount = (abs(RANDOM())%weapCount);
         this->spawnX = 10+(abs(RANDOM())%(mapSizeX-20));
         this->spawnY = 5+(abs(RANDOM())%(mapSizeY-60));
         this->respawn = Engine.crateDropRate/2 + abs(RANDOM())%(Engine.crateDropRate/2);
         traceLine(this->spawnX-1, this->spawnY-5, this->spawnX-1, this->spawnY+50, 0);
         if (trace)
         traceLine(this->spawnX+1, this->spawnY-5, this->spawnX+1, this->spawnY+50, 0);
         if (trace)
         traceLine(this->spawnX, this->spawnY-5, this->spawnX, this->spawnY+50, 0);
         if (!trace)
            return;
      }
      createSpecial(this->owner, this->spawnX, this->spawnY, medKitRespawn, &weapons[this->owner->weaps[this->owner->curWeap]], &always1);
      this->start();
   }
};

