#include "defs.h"
#include "ai.h"
#include "engine.h"
#include "items.h"
#include "sound.h"
#include "weapons.h"

void jumpPad::collision(worm *player)
{
   if (this->owner)
      return;

   this->owner = player;
   this->localTime = gameTime;
   Sound.playSound(padHit, player->coords.x, player->coords.y);
   player->vel.x = (this->amount * cosinus[this->bounce%33]) * (this->bounce > 32 ? -1 : 1) / 1000;
   player->vel.y = (this->amount * sinus[this->bounce%33]) * (this->bounce > 32 ? -1 : 1) / 1000;
};

void jumpPad::think()
{
   long distX, distY;

   if (!this->owner)
   {
      return;
   }
   if ((gameTime - this->localTime)%this->respawn == this->respawn-1)
   {
      this->owner = NULL;
   }
};


