#include "defs.h"
#include "ai.h"
#include "engine.h"
#include "items.h"
#include "sound.h"
#include "weapons.h"

void mediKit::collision(worm *player)
{
   if (this->owner)
      return; // has been picked up
   if (player->health == GP_WORM_HEALTH)
      return; // no need for health
   player->health += this->amount;
   if (player->health > GP_WORM_HEALTH)
      player->health = GP_WORM_HEALTH;
   this->owner = player;
   this->localTime = gameTime;
   Sound.playSound(medKitPickup, this->CurX, this->CurY);
};

void mediKit::blow(worm *player)
{
   if (this->owner)
      return; // has been picked up
   this->owner = player;
   this->localTime = gameTime;
   createSpecial(this->owner, this->CurX, this->CurY, itemExplosion, &weapons[this->owner->weaps[this->owner->curWeap]], &always1);
};

void mediKit::draw(gameViewport *where)
{
   BITMAP *tempWeap;
   
   if (this->owner)
      return; // has been picked up
   tempWeap = create_sub_bitmap(imgWeap, Engine.items.medikitSprite*7, 0, 7, 7);
   draw_sprite(where->leftpane, tempWeap, this->CurX - where->CurX - 3, this->CurY - where->CurY - 3);
   draw_sprite(where->sniping, tempWeap, this->CurX - where->SnipX - 3, this->CurY - where->SnipY - 3);
   destroy_bitmap(tempWeap);
};

void mediKit::think()
{
   if (!this->owner)
      return; // not picked up
   if (gameTime - this->localTime >= this->respawn)
   {
      if (Engine.crateDrops)
      {
         this->amount = Engine.crateHealthMin + (abs(RANDOM())%Engine.crateHealthVar);
         this->spawnX = 10+(abs(RANDOM())%(mapSizeX-20));
         this->spawnY = 5+(abs(RANDOM())%(mapSizeY-60));
         this->respawn = Engine.crateDropRate/2 + abs(RANDOM())%(Engine.crateDropRate/2);
         traceLine(this->spawnX-1, this->spawnY-5, this->spawnX-1, this->spawnY+50, 0);
         if (trace)
         traceLine(this->spawnX+1, this->spawnY-5, this->spawnX+1, this->spawnY+50, 0);
         if (trace)
         traceLine(this->spawnX, this->spawnY-5, this->spawnX, this->spawnY+50, 0);
         if (!trace)
            return;
      }
      createSpecial(this->owner, this->spawnX, this->spawnY, medKitRespawn, &weapons[this->owner->weaps[this->owner->curWeap]], &always1);
      this->start();
   }
};

