#include "defs.h"
#include "ai.h"
#include "console.h"
#include "engine.h"
#include "items.h"
#include "rules.h"
#include "sound.h"
#include "weapons.h"

void ctfFlag::collision(worm *player)
{
   long distX, distY;
   interact *list;

   if (this->owner)
      return; // has been picked up

   distX = this->CurX - this->spawnX;
   distY = this->CurY - this->spawnY;

   if ((player->team%2) == this->amount)
   {
      if (abs(distX) + abs(distY) > 32)
      {
         Console.WriteCF("%s returned the %s flag.", player->name, (this->amount == 0) ? "BLUE" : "RED");
         createSpecial(player, this->spawnX, this->spawnY, flagRespawn, &weapons[player->weaps[player->curWeap]], &always1);
         this->start();
         return;
      }
      list = itemList;
      while (list)
      {
         if (list->type == this->type) // another flag
         if (list->owner == player) // carried by player
         {
            Console.WriteCF("%s captured the %s flag!", player->name, (this->amount == 1) ? "BLUE" : "RED");
            createSpecial(player, list->spawnX, list->spawnY, flagRespawn, &weapons[player->weaps[player->curWeap]], &always1);
            list->start();
            giveScore(player, 5);
            checkRules();
            return;
         }
         list = list->next;
      }
      return;
   }

   this->owner = player;
   this->localTime = gameTime;
   Sound.playSound(flagPickup, this->CurX, this->CurY);
   Console.WriteCF("%s got the %s flag!", player->name, (this->amount == 0) ? "BLUE" : "RED");
};

void ctfFlag::draw(gameViewport *where)
{
   BITMAP *tempWeap;
   
   if (this->amount == 0)
      tempWeap = create_sub_bitmap(imgWeap, (Engine.items.flagSprite+1)*7, 0, 7, 7); // team 1
   else
      tempWeap = create_sub_bitmap(imgWeap, (Engine.items.flagSprite+2)*7, 0, 7, 7); // team 2
   draw_sprite(where->leftpane, tempWeap, this->CurX - where->CurX - 3, this->CurY - where->CurY - 3);
   draw_sprite(where->sniping, tempWeap, this->CurX - where->SnipX - 3, this->CurY - where->SnipY - 3);
   destroy_bitmap(tempWeap);
};

void ctfFlag::think()
{
   long distX, distY;

   if (this->owner)
   {
      this->CurX = this->owner->coords.x;
      this->CurY = this->owner->coords.y - 4;
      return; // picked up
   }
   distX = this->CurX - this->spawnX;
   distY = this->CurY - this->spawnY;
   if (abs(distX) + abs(distY) > 32) // if not in base - return
   if (gameTime - this->localTime >= this->respawn)
   {
      Console.WriteCF("The %s flag has returned.", (this->amount == 0) ? "BLUE" : "RED");
      createSpecial(&worms[0], this->spawnX, this->spawnY, flagRespawn, &weapons[worms[0].weaps[worms[0].curWeap]], &always1);
      this->start();
   }
};

void ctfFlag::ownerDead(worm *killer)
{
   if (killer->team != this->owner->team)
   {
      giveScore(killer, 1);
      checkRules();
   }
   this->VelX = this->owner->vel.x;
   this->VelY = this->owner->vel.y - Engine.wormJumpForce;
   this->x = this->owner->pos.x;
   this->y = this->owner->pos.y;
   this->owner = NULL;
   this->localTime = gameTime;
}

