#include "defs.h"
#include "ai.h"
#include "console.h"
#include "engine.h"
#include "items.h"
#include "rules.h"
#include "sound.h"
#include "weapons.h"

void domFlag::collision(worm *player)
{
   if ((this->owner) && (player->team == this->owner->team))
      return;

   this->owner = player;
   this->localTime = gameTime;
   Sound.playSound(flagPickup, this->CurX, this->CurY);
   Console.WriteCF("%s got the %s flag!", player->name, this->name);
};

void domFlag::draw(gameViewport *where)
{
   BITMAP *tempWeap;
   
   if (!this->owner)
      tempWeap = create_sub_bitmap(imgWeap, (Engine.items.flagSprite)*7, 0, 7, 7); // no owner yet
   else if (this->owner->team == 0)
      tempWeap = create_sub_bitmap(imgWeap, (Engine.items.flagSprite+1)*7, 0, 7, 7); // team 1
   else
      tempWeap = create_sub_bitmap(imgWeap, (Engine.items.flagSprite+2)*7, 0, 7, 7); // team 2
   draw_sprite(where->leftpane, tempWeap, this->CurX - where->CurX - 3, this->CurY - where->CurY - 3);
   draw_sprite(where->sniping, tempWeap, this->CurX - where->SnipX - 3, this->CurY - where->SnipY - 3);
   destroy_bitmap(tempWeap);
};

void domFlag::think()
{
   long distX, distY;

   if (!this->owner)
   {
      return; // untagged
   }
   if (!gameOver)
   if ((gameTime - this->localTime)%this->respawn == this->respawn-1)
   {
      giveScore(this->owner, 1);
      checkRules();
   }
};


