#include "allegro.h"

#ifdef _WIN32
#include "winalleg.h"

#include <winsock.h>
#else
#define SOCKET_ERROR -1
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#endif

#include "defs.h"
#include "console.h"
#include "engine.h"
#include "input.h"
#include "rules.h"
#include "sound.h"
#include "weapons.h"

#include "demos.h"

void processInput()
{                   
   int i;
   for (i=0; i<GP_NUM_PLAYERS; i++)
   {
      worms[i].flags[FL_CAN_JUMP] = (Engine.wormJumpReleasedCheck ? !worms[i].buttons[GK_JUMP] : 1);
      worms[i].flags[FL_CAN_CHANGE] = ((!worms[i].buttons[GK_LEFT]) && (!worms[i].buttons[GK_RIGHT]));
      worms[i].flags[FL_ROPE_OK] = ((!worms[i].buttons[GK_JUMP]) || (!worms[i].buttons[GK_CHANGE]));
   }
   if (gameTime%2 == 0)
   {
   if (isServer)
   {
      if (!isDedicated)
         netSendKeys();
      while ((!gotKeys) && (!key[KEY_ESC]))
      {
         networkServerProcess();
         rest(0);
      }
      gotKeys = 0;
      if (!isDedicated)
         netReceiveKeys();
      else
         return;
   }
   else
   {
      while((!gotKeys) && (!key[KEY_ESC]))
      {
         networkProcess();
         rest(0);
      }
#ifdef DEMOS
      if (!isPlaybackMode)
#endif
         netSendKeys();
      gotKeys = 0;
      netReceiveKeys();
   }
   }
   else
   {
      for (i=0; i<GP_NUM_PLAYERS; i++)
      {
         worms[i].buttons[GK_UP] = worms[i].buttons[GK_DOWN] = 0;
      }
   }
   for (i=0; i<GP_NUM_PLAYERS; i++)
   if (worms[i].active)
   if (worms[i].health>0)
   {
      if (!worms[i].buttons[GK_CHANGE])
      if (worms[i].buttons[GK_LEFT])
      {
         if ((worms[i].buttons[GK_RIGHT]) && (worms[i].dir == DIR_RIGHT))
         {
            if (worms[i].next_dig < gameTime)
               dig(&worms[i]);
         }
         if (!(worms[i].buttons[GK_RIGHT]) || (worms[i].dir == DIR_LEFT))
         if (!(worms[i].buttons[GK_RIGHT]) || (worms[i].aim > 4))
         {
            worms[i].dir = DIR_LEFT;
            if (worms[i].next_frame <= gameTime)
            {
               if (worms[i].frame == 0)
               {
                  worms[i].flags[FL_ANIM_FORWARD] = 1;
               }
               else if (worms[i].frame == 2)
               {
                  worms[i].flags[FL_ANIM_FORWARD] = 0;
               }
               if (worms[i].flags[FL_ANIM_FORWARD])
               {
                  worms[i].frame++;
               }
               else
               {
                  worms[i].frame--;
               }
               worms[i].next_frame = gameTime + GP_FRAME_DELAY;
            }
            if (worms[i].vel.x > -Engine.wormWalkLimit)
            {
               if (worms[i].flags[FL_APPLY_GRAV])
               {
                  worms[i].vel.x -= (Engine.wormWalkAccel * Engine.wormAirControl)/1000;
               }
               else
               {
                  worms[i].vel.x -= Engine.wormWalkAccel;
               }
            }
         }
      }
      if (!worms[i].buttons[GK_CHANGE])
      if (worms[i].buttons[GK_RIGHT])
      {
         if ((worms[i].buttons[GK_LEFT]) && (worms[i].dir == DIR_LEFT))
         {
            if (worms[i].next_dig < gameTime)
               dig(&worms[i]);
         }
         if (!(worms[i].buttons[GK_LEFT]) || (worms[i].dir == DIR_RIGHT))
         if (!(worms[i].buttons[GK_LEFT]) || (worms[i].aim > 4))
         {
            worms[i].dir = DIR_RIGHT;
            if (worms[i].next_frame <= gameTime)
            {
               if (worms[i].frame == 0)
               {
                  worms[i].flags[FL_ANIM_FORWARD] = 1;
               }
               else if (worms[i].frame == 2)
               {
                  worms[i].flags[FL_ANIM_FORWARD] = 0;
               }
               if (worms[i].flags[FL_ANIM_FORWARD])
               {
                  worms[i].frame++;
               }
               else
               {
                  worms[i].frame--;
               }
               worms[i].next_frame = gameTime + GP_FRAME_DELAY;
            }
            if (worms[i].vel.x < Engine.wormWalkLimit)
            {
               if (worms[i].flags[FL_APPLY_GRAV])
               {
                  worms[i].vel.x += (Engine.wormWalkAccel * Engine.wormAirControl)/1000;
               }
               else
               {
                  worms[i].vel.x += Engine.wormWalkAccel;
               }
            }
         }
      }
      if (!worms[i].buttons[GK_CHANGE])
      {
         if (worms[i].buttons[GK_UP])
         {
            if (worms[i].aimStarted == 0)
            {
               worms[i].aimStarted = gameTime;
            }   
            if (worms[i].next_aim <= gameTime)
            if (worms[i].aim < Engine.wormMaxAngle)
            {
               worms[i].aim++;

               if (Engine.wormAimAccelDelay)
               if (worms[i].aimStarted + Engine.wormAimAccelDelay <= gameTime)
               if (worms[i].aim < Engine.wormMaxAngle)
                  worms[i].aim++;

               worms[i].next_aim = gameTime + GP_AIM_DELAY;
            }
         }
         else if (worms[i].buttons[GK_DOWN])
         {
            if (worms[i].aimStarted == 0)
            {
               worms[i].aimStarted = gameTime;
            }   
            if (worms[i].next_aim <= gameTime)
            if (worms[i].aim > Engine.wormMinAngle)
            {        
               worms[i].aim--;

               if (Engine.wormAimAccelDelay)
               if (worms[i].aimStarted + Engine.wormAimAccelDelay <= gameTime)
               if (worms[i].aim > Engine.wormMinAngle)
                  worms[i].aim--;

               worms[i].next_aim = gameTime + GP_AIM_DELAY;
            }
         }
         else if (gameTime % 2 == 0)
         {
            worms[i].aimStarted = 0;   
         }      
      }
      else
      {
         if (worms[i].buttons[GK_UP])
         {
            if (worms[i].ropeLen > 0)
            {
               worms[i].ropeLen--;
            }
         }
         if (worms[i].buttons[GK_DOWN])
         {
            if (worms[i].ropeLen < Engine.rope.maxLen)
            {
               worms[i].ropeLen++;
            }
         }
      }
      if (!worms[i].buttons[GK_LEFT] && !worms[i].buttons[GK_RIGHT])
      {
         worms[i].frame = 1;
      }
      if ((worms[i].buttons[GK_CHANGE]) && (worms[i].buttons[GK_JUMP]) && (worms[i].flags[FL_ROPE_OK]))
      {
         if (tactics)
         {
            if (worms[i].ammo[worms[i].curWeap] > 0)
            if (worms[i].ammo[worms[i].curWeap] < weapons[worms[i].weaps[worms[i].curWeap]].maxAmmo)
            {
               worms[i].ammo[worms[i].curWeap] = 0;
            }
            worms[i].flags[FL_CAN_JUMP] = 0;
         }
         else if (Engine.rope.enabled)
         {
            if (worms[i].next_rope <= gameTime)
            {
               Sound.playSound(ropeSound, worms[i].coords.x, worms[i].coords.y);
               worms[i].next_rope = gameTime + 10;
            }
   
            worms[i].flags[FL_CAN_JUMP] = 0;
            worms[i].flags[FL_ROPE_OUT] = 1;
            worms[i].flags[FL_ROPE_HIT] = 0;
            worms[i].flags[FL_ROPE_PULL] = 0;
            worms[i].flags[FL_GOT_ENEMY] = 0;
            if (worms[i].dir == DIR_RIGHT)
            {
               worms[i].rope.x = worms[i].pos.x + Engine.weapSpawnDist * cosinus[worms[i].aim];
               worms[i].ropevel.x = (Engine.rope.initSpeed * cosinus[worms[i].aim])/1000 + (worms[i].vel.x * Engine.rope.affectedByWorm)/1000;
            }
            else
            {
               worms[i].rope.x = worms[i].pos.x - Engine.weapSpawnDist * cosinus[worms[i].aim];
               worms[i].ropevel.x = -(Engine.rope.initSpeed * cosinus[worms[i].aim])/1000 + (worms[i].vel.x * Engine.rope.affectedByWorm)/1000;
            }
            worms[i].rope.y = worms[i].pos.y + Engine.wormFireOffs * 1000 + Engine.weapSpawnDist * sinus[worms[i].aim];
            worms[i].ropevel.y = (Engine.rope.initSpeed * sinus[worms[i].aim])/1000 + (worms[i].vel.y * Engine.rope.affectedByWorm)/1000;
            worms[i].ropecoords.x = worms[i].rope.x/1000;
            worms[i].ropecoords.y = worms[i].rope.y/1000;
         }
      }
      else if ((worms[i].buttons[GK_CHANGE]) && (worms[i].flags[FL_CAN_CHANGE]))
      {
         if (worms[i].buttons[GK_LEFT])
         {
            worms[i].curWeap--;
            if (worms[i].curWeap<0)
               worms[i].curWeap = 4;
         }
         if (worms[i].buttons[GK_RIGHT])
         {
            worms[i].curWeap++;
            if (worms[i].curWeap>4)
               worms[i].curWeap = 0;
         }
      }
      else if ((worms[i].buttons[GK_JUMP]) && (worms[i].flags[FL_CAN_JUMP]))
      {
         worms[i].flags[FL_ROPE_OUT] = 0;
      }
      if ((worms[i].buttons[GK_FIRE]) && (!worms[i].buttons[GK_CHANGE]) && (worms[i].next_fire[worms[i].curWeap] <= gameTime) && (worms[i].localTime + Engine.wormSafeTime <= gameTime))
      {
         fireWeapon(&worms[i]);
      }
   }
}

