#include "demos.h"

#include "fcntl.h"

#include "defs.h"
#include "console.h"
#include "engine.h"
#include "items.h"
#include "netio.h"
#include "packet.h"
#include "player.h"
#include "rules.h"

#ifdef DEMOS
int isDemoMode = 0;
int isPlaybackMode = 0;

PACKFILE *demoFile = NULL;

void StartRecording(char *name)
{
    int i;
    demoFile = pack_fopen(name, "wp");

    Console.WriteF("Recording to %s...", name);
}

void StartPlayback(char *name)
{
    int i;
    demoFile = pack_fopen(name, "rp");
    
    Console.WriteF("Playing from %s...", name);
}

void savePacket(char *buf, int size)
{
   pack_fwrite(buf, size, demoFile);
}

void demoJoinPackets()
{
   int i, n;

   for(n = 0; n < GP_MAX_PLAYERS; n++) {
      if(worms[n].active) {

         Packet(PACKET_JOIN);
         PacketAddByte(n);
         PacketAddByte(worms[n].team);
         PacketAddByte(worms[n].skin);
         for (i=0; i<21; i++)
         {
            PacketAddByte(worms[n].name[i]);
         }
         savePacket((char *)packetsend, PACKET_JOIN_SIZE);
      }
   }

   for(n = 0; n < GP_MAX_PLAYERS; n++) {
      if(worms[n].active) {
       	 Packet(PACKET_WEAP);
		 PacketAddByte(n);
         for (i=0; i < 5; i++)
         {
            PacketAddByte(worms[n].weaps[i]);
         }
         savePacket((char *)packetsend, PACKET_WEAP_SIZE);
      }
   }
   Packet(PACKET_MAPN);
   for (n = 0; n < 21; n++)
   {
      PacketAddByte(mapName[n]);
   }
   savePacket((char *)packetsend, PACKET_MAPN_SIZE);
   TheGamePacket();
   savePacket((char *)packetsend, PACKET_GAME_SIZE);
   Packet(PACKET_PLNM);
   PacketAddByte(GP_NUM_PLAYERS);
   savePacket((char *)packetsend, PACKET_PLNM_SIZE);
}

int readPacket()
{
   char type;
   type = pack_fread(&packetbuffer[0], 1, demoFile);

   if (type == 0)
      return 0;
   type = packetbuffer[0];
   switch(type)
   {
   case (PACKET_MAPN):
      pack_fread(&packetbuffer[1], PACKET_MAPN_SIZE-1, demoFile);
      break;
   case (PACKET_JOIN):
      pack_fread(&packetbuffer[1], PACKET_JOIN_SIZE-1, demoFile);
      break;
   case (PACKET_MOVE):
      pack_fread(&packetbuffer[1], PACKET_MOVE_SIZE-1, demoFile);
      break;
   case (PACKET_QUIT):
      pack_fread(&packetbuffer[1], PACKET_QUIT_SIZE-1, demoFile);
      break;
   case (PACKET_WEAP):
      pack_fread(&packetbuffer[1], PACKET_WEAP_SIZE-1, demoFile);
      break;
   case (PACKET_STRT):
      pack_fread(&packetbuffer[1], PACKET_STRT_SIZE-1, demoFile);
      break;
   case (PACKET_PLNM):
      pack_fread(&packetbuffer[1], PACKET_PLNM_SIZE-1, demoFile);
      break;
   case (PACKET_GAME):
      pack_fread(&packetbuffer[1], PACKET_GAME_SIZE-1, demoFile);
      break;
   case (PACKET_CHAT):
      pack_fread(&packetbuffer[1], PACKET_CHAT_SIZE-1, demoFile);
      break;
   case (PACKET_LOCL):
      pack_fread(&packetbuffer[1], PACKET_LOCL_SIZE-1, demoFile);
      break;
   default:
      sprintf(buf, "Fucked-packet at %d: %d", pack_fseek(demoFile, 0), type);
      allegro_message(buf);
   }
   return 1;
}

void FreeDemo()
{
   pack_fclose(demoFile);
}
#endif
