#include "defs.h"
#include "engine.h"
#include "ai.h"
#include "ai_waypt.h"
#include "math.h"
#include "maths.h"
#include "rules.h"

#include "console.h"

void ai_process_st_run(worm *tmpWorm)
{
   char keyz[7] = {0, 0, 0, 0, 0, 0, 0};
   unsigned char tmp;
   double px, py, dist;
   long tl, vx, vy, tvx, tvy, affect, pLoop;
   int sx, sy, angle, i;
   int bestWeap, chLeft=0, chRight=0;
   waypoint *tmpWay;

   if (tmpWorm->enemy)
   {
      tmpWorm->aiState = AI_STATE_ENEMY;
   }
   if (tmpWorm->dest)
   {
      traceLine(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWorm->dest->x, tmpWorm->dest->y, 0);
   }
   else
   {
      sx = findSafePt(tmpWorm, tmpWorm->coords.x, tmpWorm->coords.y);
      if (sx == -1)
         tmpWorm->aiState = AI_STATE_NONE;
      else
      {
         tmpWorm->dest = &waypts[sx];
         traceLine(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWorm->dest->x, tmpWorm->dest->y, 0);
      }
   }

   if ((tmpWorm->dest) && (trace))
   {
      if (tmpWorm->health <= 0)
      if ((tmpWorm->lives > 0) || (gameType != GAME_KTA))
      if (tmpWorm->next_spawn + 90 - GP_WORM_RESPAWN < gameTime)
      {
         keyz[GK_CHANGE] = 1;
      }

      angle = 16;

      if (angle > tmpWorm->aim)
      {
         keyz[GK_UP] = 1;
      }
      else
      if (angle < tmpWorm->aim)
      {
         keyz[GK_DOWN] = 1;
      }

      tmpWorm->aiPath = -1;

      if ((tmpWorm->coords.x - 10 > tmpWorm->dest->x) || ((tmpWorm->dest->x < tmpWorm->coords.x) && (tmpWorm->dir != DIR_LEFT)))
      {
         keyz[GK_LEFT] = 1;
      }
      else
      if ((tmpWorm->coords.x + 10 < tmpWorm->dest->x) || ((tmpWorm->dest->x > tmpWorm->coords.x) && (tmpWorm->dir != DIR_RIGHT)))
      {
         keyz[GK_RIGHT] = 1;
      }

      if (!tactics)
      if (!tmpWorm->flags[FL_ROPE_OUT])
      {
      }
      else
      if (!keyz[GK_CHANGE])
      if (tmpWorm->flags[FL_CAN_JUMP])
      {
         if (tmpWorm->coords.y - 5 < tmpWorm->dest->y)
         {
            keyz[GK_JUMP] = 1;
         }
         if (tmpWorm->coords.y < tmpWorm->ropecoords.y)
         if (abs(tmpWorm->vel.y)<2000)
         {
            keyz[GK_JUMP] = 1;
         }
         if ((angle <= 4) && (tmpWorm->aim <= 4))
         {
            keyz[GK_JUMP] = 1;
         }
      }

      bestWeap = getBestWeap(tmpWorm, 1);
      chLeft = tmpWorm->curWeap - bestWeap;
      if (chLeft < 0)
         chLeft += 5;
      chRight = bestWeap - tmpWorm->curWeap;
      if (chRight < 0)
         chRight += 5;   

      if (tmpWorm->curWeap != bestWeap)
      if (tmpWorm->flags[FL_CAN_CHANGE])
      if (!keyz[GK_JUMP])
      {
         keyz[GK_CHANGE] = 1;
         keyz[GK_LEFT] = (chLeft < chRight ? 1 : 0);
         keyz[GK_RIGHT] = (chLeft > chRight ? 1 : 0);
      }
      
      if (!aiNeedReload(tmpWorm))
      {
         tmpWorm->dest = NULL;
         tmpWorm->aiState = AI_STATE_NONE;
      }
   }
   else if (tmpWorm->dest)
   {
      if (tmpWorm->aiPath == -1)
//      if (!findBotPath(tmpWorm, tmpWorm->dest->x, tmpWorm->dest->y))
      {
         tmpWorm->dest = NULL;
         tmpWorm->aiState = AI_STATE_NONE;
      }
   }

   if (useWayPts)
   if (tmpWorm->aiPath != -1)
   {
      tmpWay = &waypts[tmpWorm->aiPath];

      bestWeap = getBestWeap(tmpWorm, 1);
      chLeft = tmpWorm->curWeap - bestWeap;
      if (chLeft < 0)
         chLeft += 5;
      chRight = bestWeap - tmpWorm->curWeap;
      if (chRight < 0)
         chRight += 5;   

      if (tmpWorm->curWeap != bestWeap)
      if (tmpWorm->flags[FL_CAN_CHANGE])
      if (!keyz[GK_JUMP])
      {
         keyz[GK_CHANGE] = 1;
         keyz[GK_LEFT] = (chLeft < chRight ? 1 : 0);
         keyz[GK_RIGHT] = (chLeft > chRight ? 1 : 0);
      }

      px = abs(tmpWay->x - tmpWorm->coords.x);
      py = tmpWay->y - tmpWorm->coords.y;
      dist = hypot(px, py);

      if (tmpWorm->aiFlags & AI_FLAG_ROPE)
         angle = 32;
      else
         angle = 16;

      if (!keyz[GK_CHANGE])
      if (angle > tmpWorm->aim)
      {
         keyz[GK_UP] = 1;
      }
      else
      if (angle < tmpWorm->aim)
      {
         keyz[GK_DOWN] = 1;
      }

      if (!keyz[GK_CHANGE])
      if (tmpWay->x > tmpWorm->coords.x + 3)
      {
         keyz[GK_RIGHT] = 1;
      }
      else if (tmpWay->x < tmpWorm->coords.x - 3)
      {
         keyz[GK_LEFT] = 1;
      }
      else
      {
      
         if (tmpWorm->aiFlags & AI_FLAG_ROPE)
         if (!tmpWorm->flags[FL_ROPE_OUT])
         if (tmpWorm->coords.y > tmpWay->y)
         if (tmpWorm->aim == angle)
         {
            keyz[GK_JUMP] = 1;
            keyz[GK_CHANGE] = 1;
         }
         keyz[GK_LEFT] = (tmpWorm->vel.x > 500);
         keyz[GK_RIGHT] = (tmpWorm->vel.y < -500);
      }

      if (!keyz[GK_CHANGE])
      if (tmpWorm->flags[FL_ROPE_OUT])
      if (
          (tmpWorm->coords.y <= tmpWay->y) ||
          (tmpWorm->coords.y <= tmpWorm->ropecoords.y) ||
          (!tmpWorm->aiFlags & AI_FLAG_ROPE) ||
          (tmpWorm->flags[FL_GOT_ENEMY])
         )
      {
         keyz[GK_JUMP] = 1;
      }

      if (!keyz[GK_CHANGE])
      if (tmpWorm->aiFlags & AI_FLAG_JUMP)
      if (tmpWorm->flags[FL_CAN_JUMP])
      {
         keyz[GK_JUMP] = 1;
      }

      if (dist < 10)
      {
         tmpWorm->aiDist = 99999999;
         if (tmpWorm->dest == tmpWay)
            tmpWorm->dest = NULL;
         tmpWorm->aiPath = -1;
         if (tmpWorm->aiState == AI_STATE_WANDER)
            tmpWorm->aiState = AI_STATE_NONE;
      }
      else
      {
         traceLine(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWay->x, tmpWay->y, 0);
   
         if (dist < tmpWorm->aiDist - 10)
         {
            tmpWorm->aiDist = int(dist);
            if (trace)
               tmpWorm->chaseTime = gameTime + 90;
         }
         if (tmpWorm->chaseTime < gameTime)
            tmpWorm->aiPath = -1;
      }
   }
   else
   {
      if (tmpWorm->flags[FL_ROPE_OUT])
      if (tmpWorm->flags[FL_CAN_JUMP])
      {
         keyz[GK_JUMP] = 1;
      }
   }

   tmp = 0;

   if (keyz[GK_JUMP]) tmp += KP_JUMP;
   if (keyz[GK_FIRE]) tmp += KP_FIRE;
   if (keyz[GK_CHANGE]) tmp += KP_CHANGE;
   if (keyz[GK_LEFT]) tmp += KP_LEFT;
   if (keyz[GK_RIGHT]) tmp += KP_RIGHT;
   if (keyz[GK_UP]) tmp += KP_UP;
   if (keyz[GK_DOWN]) tmp += KP_DOWN;

   bufor[tmpWorm->num] = tmp;
   worms[tmpWorm->num].sentKeys = 1;
}


