#include "defs.h"
#include "engine.h"
#include "ai.h"
#include "ai_waypt.h"
#include "math.h"
#include "maths.h"
#include "rules.h"
#include "weapons.h"

void ai_process_st_none(worm *tmpWorm)
{
   worm *enemy = NULL;
   char keyz[7] = {0, 0, 0, 0, 0, 0, 0};
   unsigned char tmp;
   double px, py, dist;
   long tl, tm, vx, vy, tvx, tvy, affect, pLoop;
   int sx, sy, angle, i;
   int bestWeap, chLeft=0, chRight=0;

   long distLeft, distRight;
   
   bestWeap = getBestWeap(tmpWorm, 1);
   chLeft = tmpWorm->curWeap - bestWeap;
   if (chLeft < 0)
      chLeft += 5;
   chRight = bestWeap - tmpWorm->curWeap;
   if (chRight < 0)
      chRight += 5;   

   if (tmpWorm->flags[FL_ROPE_OUT])
      keyz[GK_JUMP]=1;

   if (tmpWorm->curWeap != bestWeap)
   if (tmpWorm->flags[FL_CAN_CHANGE])
   if (!keyz[GK_JUMP])
   {
      keyz[GK_CHANGE] = 1;
      keyz[GK_LEFT] = (chLeft < chRight ? 1 : 0);
      keyz[GK_RIGHT] = (chLeft > chRight ? 1 : 0);
   }

   if (!aiNeedReload(tmpWorm))
   for (i=0; i<GP_NUM_PLAYERS; i++)
   if (tmpWorm != &worms[i])
   if (worms[i].coords.x >= tmpWorm->aiCurX)
   if (worms[i].coords.x < tmpWorm->aiCurX+320)
   if (worms[i].coords.y >= tmpWorm->aiCurY)
   if (worms[i].coords.y < tmpWorm->aiCurY+150)
   if (worms[i].active)
   if (worms[i].localTime + Engine.wormSafeTime <= gameTime)
   if (worms[i].health>0)
   if ((!teamplay) || (worms[i].team != tmpWorm->team))
   if (
       (gameType != GAME_PRD) || 
       (
        (worms[i].flags[FL_PREDATOR]) && // predator and visible
        (
         (
          (INT(hypot(worms[i].vel.x, worms[i].vel.y)*255.0/3000.0)>63) ||
          (worms[i].show_fire > gameTime) ||
          (worms[i].flags[FL_ROPE_OUT]) ||
          (weapons[worms[i].weaps[worms[i].curWeap]].laserSight >= 0)
         )
        )
       ) ||
       (!predator->flags[FL_PREDATOR]) || // no predator
       (
        (tmpWorm->flags[FL_PREDATOR]) &&
        (hypot(tmpWorm->coords.x - worms[i].coords.x, tmpWorm->coords.y - worms[i].coords.y) < 50.0)
       )
      )
   if ((gameType != GAME_TAG) || (teamplay && (predator->team == tmpWorm->team)) ||(worms[i].flags[FL_PREDATOR]) || (!predator->flags[FL_PREDATOR]) || (tmpWorm->flags[FL_PREDATOR]))
   if ((!tactics) || (visible(tmpWorm, worms[i].coords.x, worms[i].coords.y + Engine.wormFireOffs)))
   {
      if (!tmpWorm->enemy)
      {
         px = hypot(tmpWorm->coords.x - worms[i].coords.x, tmpWorm->coords.y - worms[i].coords.y);
         tmpWorm->enemy = &worms[i];
         continue;
      }
      py = hypot(tmpWorm->coords.x - worms[i].coords.x, tmpWorm->coords.y - worms[i].coords.y);
      if (py < px)
      {
         px = py;
         tmpWorm->enemy = &worms[i];
      }
   }
   
   if (!tmpWorm->enemy)
   {
      if (aiNeedReload(tmpWorm))
      {
         sx = findSafePt(tmpWorm, tmpWorm->coords.x, tmpWorm->coords.y);
         if (sx != -1)
         {
            tmpWorm->aiState = AI_STATE_RUN;
            tmpWorm->dest = &waypts[sx];
         }
         
      }
      if (!keyz[GK_CHANGE])
      {

         traceWalk(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWorm->coords.x - AI_WALK_DIST, tmpWorm->coords.y + Engine.wormFireOffs, 1);
         distLeft = tmpWorm->coords.x - traceX;
         traceWalk(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWorm->coords.x + AI_WALK_DIST, tmpWorm->coords.y + Engine.wormFireOffs, 1);
         distRight = traceX - tmpWorm->coords.x;

         if (tmpWorm->flags[FL_ROPE_OUT])
         {
            keyz[GK_JUMP] = 1;
         }

         if ((gameType != GAME_PRD) || (!tmpWorm->flags[FL_PREDATOR]))
         if (distLeft < distRight)
         {
            traceWalk(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs - AI_JUMP_DIST, 1);
            if (trace)
               traceWalk(traceX, traceY, traceX + 2*AI_WALK_DIST, traceY, 1);
            if (trace)
            if (tmpWorm->flags[FL_CAN_JUMP])
            {
               keyz[GK_JUMP] = 1;
            }
            else
            {
               keyz[GK_RIGHT] = 1;
               keyz[GK_LEFT] = (tmpWorm->dir == DIR_RIGHT ? 1 : 0);
            }
         }
         else
         if (distLeft > distRight)
         {
            traceWalk(tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs, tmpWorm->coords.x, tmpWorm->coords.y + Engine.wormFireOffs - AI_JUMP_DIST, 1);
            if (trace)
               traceWalk(traceX, traceY, traceX - 2*AI_WALK_DIST, traceY, 1);
            if (trace)
            if (tmpWorm->flags[FL_CAN_JUMP])
            {
               keyz[GK_JUMP] = 1;
            }
            else
            {
               keyz[GK_LEFT] = 1;
               keyz[GK_RIGHT] = (tmpWorm->dir == DIR_RIGHT ? 0 : 1);
            }
         }
         else
         {
            keyz[GK_RIGHT] = 1;
            keyz[GK_LEFT] = 1;
         }
      
         angle=16;
         if (angle > tmpWorm->aim)
         {
            keyz[GK_UP] = 1;
         }
         else
         if (angle < tmpWorm->aim)
         {
            keyz[GK_DOWN] = 1;
         }
      }
      if (useWayPts)
      {
         if (!tmpWorm->dest)
            tmpWorm->dest = &waypts[rand()%numWayPts];
         tmpWorm->aiDist = 99999999;
         tmpWorm->aiState = AI_STATE_WANDER;
      }
   }
   else
   {
      tmpWorm->aiState = AI_STATE_ENEMY;
      tmpWorm->enemyTime = gameTime + 90 + (600 * useWayPts);
   }

   tmp = 0;

   if (keyz[GK_JUMP]) tmp += KP_JUMP;
   if (keyz[GK_FIRE]) tmp += KP_FIRE;
   if (keyz[GK_CHANGE]) tmp += KP_CHANGE;
   if (keyz[GK_LEFT]) tmp += KP_LEFT;
   if (keyz[GK_RIGHT]) tmp += KP_RIGHT;
   if (keyz[GK_UP]) tmp += KP_UP;
   if (keyz[GK_DOWN]) tmp += KP_DOWN;

   bufor[tmpWorm->num] = tmp;
   worms[tmpWorm->num].sentKeys = 1;
}

