#include "allegro.h"

#ifdef _WIN32

#include "winalleg.h"
#include <winsock.h>

#endif

#include "defs.h"
#include "console.h"
#include "ai.h"
#include "ai_waypt.h"
#include "engine.h"
#include "gfx.h"
#include "math.h"
#include "maths.h"
#include "network.h"
#include "player.h"
#include "rules.h"
#include "server.h"

extern "C" {
	#include "lua.h"
	#include "lualib.h"
	#include "lauxlib.h"
}

#include "ai_lua.h"
#include "ai_lua_wrap.h"

void initLuaAI()
{
   int i, j = 0;
   char tmp[255];

   aiLuaSetConsts();

   override_config_file("Bots.cfg");
   for (i=0; i<GP_NUM_PLAYERS; i++)
   {
      if (worms[i].isAi)
      {
         sprintf(buf, "Bot.%d", i-j);
         sprintf(buf, "%s", get_config_string("wurmz!",buf,"player.cfg"));
         override_config_file(buf);

         sprintf(tmp, "bots/%s", get_config_string("AI", "Script", "default.lua"));
         aiLuaInit(&worms[i], tmp);
         
         override_config_file("Bots.cfg");
      }
      else
      {
         j++;
      }
   }
}

void aiLuaInit(worm *player, char *script)
{
   lua_State* L;

	int i;

   for (i = 0; i < GP_NUM_PLAYERS; i++)
      if (&worms[i] == player) break;

/* initialize Lua */
	L = lua_open();

	luaopen_math(L);

	/* register our functions */
	lua_register(L, "getWormPos", getWormPos);
	lua_register(L, "getWormVel", getWormVel);
	lua_register(L, "getWormAim", getWormAim);
	lua_register(L, "getWormDir", getWormDir);
	lua_register(L, "getWormTeam", getWormTeam);
	lua_register(L, "getWormHealth", getWormHealth);
	lua_register(L, "getWormFlag", getWormFlag);
	lua_register(L, "getRopePos", getRopePos);
	lua_register(L, "findWaypoint", findWaypoint);
	lua_register(L, "findPath", findPath);
	lua_register(L, "getWaypointPos", getWaypointPos);
	lua_register(L, "aim", aiLuaAim);
	lua_register(L, "aimToVec", aiLuaAimToVec);
	lua_register(L, "print", aiLuaPrint);
	lua_register(L, "trace", aiLuaTrace);
	lua_register(L, "getFlag", getFlag);
	
   lua_dofile(L, "bots/includes.inc");

	/* run the script */
	lua_dofile(L, script);

	lua_pushstring(L, "self");
	lua_pushnumber(L, i);
	lua_settable(L, LUA_GLOBALSINDEX);

	lua_pushstring(L, "numWorms");
	lua_pushnumber(L, GP_NUM_PLAYERS);
	lua_settable(L, LUA_GLOBALSINDEX);

	lua_pushstring(L, "jumpNotOnGround");
	lua_pushboolean(L, !Engine.wormJumpOnGroungCheck);
	lua_settable(L, LUA_GLOBALSINDEX);

	lua_pushstring(L, "jumpNotReleased");
	lua_pushboolean(L, !Engine.wormJumpReleasedCheck);
	lua_settable(L, LUA_GLOBALSINDEX);

	lua_pushstring(L, "jumpForce");
	lua_pushnumber(L, Engine.wormJumpForce);
	lua_settable(L, LUA_GLOBALSINDEX);

	player->aiScript = L;
}

void aiLuaFree(worm *player)
{
   if (player->aiScript)
   	lua_close(player->aiScript);
}

int aiGetMove (worm *player)
{
	int val;
	int i;

	lua_pushstring(player->aiScript, "curWeap");
	lua_pushnumber(player->aiScript, player->curWeap+1);
	lua_settable(player->aiScript, LUA_GLOBALSINDEX);

	lua_pushstring(player->aiScript, "time");
	lua_pushnumber(player->aiScript, gameTime);
	lua_settable(player->aiScript, LUA_GLOBALSINDEX);

	lua_pushstring(player->aiScript, "weapons");
	lua_newtable(player->aiScript);

	for (i = 0; i < 5; i++)
   {
	   lua_pushnumber(player->aiScript, i+1);
	   lua_pushnumber(player->aiScript, player->weaps[i]+1);
	   lua_settable(player->aiScript, -3);
   }

	lua_settable(player->aiScript, LUA_GLOBALSINDEX);

	lua_pushstring(player->aiScript, "ammo");
	lua_newtable(player->aiScript);

	for (i = 0; i < 5; i++)
   {
	   lua_pushnumber(player->aiScript, i+1);
	   lua_pushnumber(player->aiScript, player->ammo[i]);
	   lua_settable(player->aiScript, -3);
   }

	lua_settable(player->aiScript, LUA_GLOBALSINDEX);

	lua_pushstring(player->aiScript, "fireDelay");
	lua_newtable(player->aiScript);

	for (i = 0; i < 5; i++)
   {
	   lua_pushnumber(player->aiScript, i+1);
	   lua_pushnumber(player->aiScript, player->next_fire[i] - gameTime);
	   lua_settable(player->aiScript, -3);
   }

	lua_settable(player->aiScript, LUA_GLOBALSINDEX);

	lua_pushstring(player->aiScript, "loadDelay");
	lua_newtable(player->aiScript);

	for (i = 0; i < 5; i++)
   {
	   lua_pushnumber(player->aiScript, i+1);
	   lua_pushnumber(player->aiScript, player->reload[i] - gameTime);
	   lua_settable(player->aiScript, -3);
   }

	lua_settable(player->aiScript, LUA_GLOBALSINDEX);

	/* the function name */
	lua_getglobal(player->aiScript, "aiGetMove");

	/* call the function with 2
	   arguments, return 1 result */
	lua_call(player->aiScript, 0, 1);

	/* get the result */
	val = (int)lua_tonumber(player->aiScript, -1);
	
	lua_pop(player->aiScript, 1);

	return val;
}


