#include <fmod.h>

class sampleItem {
public:
   int num;
   int priority;
   FSOUND_SAMPLE *soundData;
   sampleItem *prev, *next;
};

class soundEngine
{
   sampleItem *sampleList;
   FSOUND_STREAM *music;
public:
   int Start();
   void Free();
   int initSounds();
   void freeSounds();
   void playSound(int i, int x, int y);
   int loopSound(int i, int x, int y, long velx, long vely);
   void updateSound(int i, int x, int y, long velx, long vely);
   void stopSound(int i);
   void startMusic(char *name);
   void preFrame();
   void postFrame();
};

extern soundEngine Sound;

#define SOUND_MAX_DIST 300
#define SOUND_NO_STEREO 10
#define SOUND_FULL_STEREO 80

