void engineWorldCollision(worm *tmpWorm);
void engineLineCollision(worm *tmpWorm);
void engineLinePull(worm *tmpWorm);
void enginePhysics();
void engineWeapPhysics();
void engineShrapPhysics();

void engineWeapTiming();
void engineShrapTiming();
void engineSpecialTiming();

void cutHole(BITMAP *hole, int x, int y);
void drawHole(BITMAP *hole, int x, int y);

#define FX_NONE 0
#define FX_SNOW 1
#define FX_RAIN 2
#define FX_STORM 3

class weatherParticle
{
public:
   int x, y;
   int spd;
};

class weatherEngine
{
   weatherParticle *particles;
   int effect;
   long nextLightning;
   void lightning(BITMAP* where, int x, int y, int i, int dx);
public:
   int numParticles;
   int lightningTime;
   int lightningColor;
   int snowParticle;
   int rainColor;
   void effectStart(int fx);
   void effectRun();
   void PreDraw(gameViewport *where);
   void PostDraw(gameViewport *where);
   void effectStop();
};

class engine
{
public:
   char renderMovie;
   int wormSizeX, wormSizeYMin, wormSizeYMax, wormFireOffs;
   int wormGravity, wormFriction, wormJumpForce, wormAirControl;
   int wormSafeTime, wormSafeSprite;
   long wormBounceLeft, wormBounceRight, wormBounceUp, wormBounceDown;
   long wormWalkAccel, wormWalkLimit, wormTermVelocity;
   int wormMinAngle, wormMaxAngle;
   char wormJumpOnGroungCheck, wormJumpReleasedCheck;
   unsigned int wormFriendlyFire, wormAimAccelDelay;
   unsigned int weapLoadTime;
   struct {
      int flagSprite, medikitSprite, weappackSprite;
      char drawNamesOnBonuses;
      long fireProbability;
   } items;
   struct {
      int x, y;
   } firePos[9];
   struct {
      char enabled;
      long affectedByWorm;
      long gravity;
      int physicsLoop;
      long initSpeed;
      int defaultLen, maxLen;
      char sticky;
   } rope;
   int weapSpawnDist;
   int crosshairDist, laserDist;
   char crateDrops;
   int crateHealthMin, crateHealthVar, crateWeapCount, crateHealthCount, crateDropRate;
   int hurtMaterialAmount, hurtMaterialFrequency;
   char wormRandomSpawn;
   struct {
      unsigned int serverPort;
   } network;
};

extern engine Engine;
extern weatherEngine Weather;

#define MAT_BLOCK_WORM makecol(0, 0, 128)
#define MAT_WORM_JUMP makecol(0, 0, 64)
#define MAT_WORM_KICK makecol(0, 0, 32)
#define MAT_DESTROYABLE makecol(0, 128, 0)
#define MAT_WORM_SLIDE makecol(0, 64, 0)
#define MAT_WORM_HURT makecol(0, 32, 0)
#define MAT_BLOCK_WEAP makecol(128, 0, 0)
#define MAT_BLOCK_ROPE makecol(64, 0, 0)

