-- constants
GAME_KTA = 0
GAME_FFA = 1
GAME_PRD = 2
GAME_CTF = 3
GAME_TAG = 4
GAME_DOM = 5

WEAP_HAS_AMMO = 1000
WEAP_CAN_KILL = 100
WEAP_CURRENT = 100

gamekeys = { jump = 1; fire = 2; change = 4; left = 8; right = 16; up = 32; down = 64; };


-- custom variables
enemy = nil; -- current enemy
direction = 1; -- for random wandering



function onDamage(other, amount)
	if (other ~= self) then
		enemy = other;
	end
end

function getBestWeap(reload)

	local best = curWeap;
	local bestScore = -999999;

	local enemyHealth = 0;

	local dist;

	if (enemy ~= nil) then

		local sx, sy = getWormPos(self);
		local ex, ey = getWormPos(enemy);
		local dx = ex - sx;
		local dy = ey - sy;
		dist = math.sqrt(dx*dx + dy*dy);

		enemyHealth = getWormHealth(enemy);

		if (dist == 0) then

			dist = 1;

		end

	else

		dist = 1;

	end

	for i = 1, 5, 1 do

		local weapon = weapons[i];

		local score = 0;

		if (dist < weaponData[weapon].maxRange) then

			if (i == curWeap) then

				score = score + WEAP_CURRENT;

			end

			if not reload then

				if (ammo[i] > 0) then

					score = score + WEAP_HAS_AMMO;

				end

				if (weaponData[weapon].avgDamage >= enemyHealth) then

					score = score + WEAP_CAN_KILL;

				end

				if (fireDelay[i] > 0) then

					score = score - fireDelay[i];

				end

				score = score - weapon.initSpeed / dist;

			else

				if (weapon.loadTime == -1) then

					score = -999999;

				else

					if (ammo[i] == 0) then

						score = score + WEAP_HAS_AMMO;

					end

					if (loadDelay[i] > 0) then

						score = score - loadDelay[i];

					end
					
				end

			end

			if (score > bestScore) then

				bestScore = score;
				best = i;

			end

		end

	end

	return best;
end


function getPointToAim()

	local sx, sy = getWormPos(self);
	local svx, svy = getWormVel(self);
	local ex, ey = getWormPos(enemy);
	local evx, evy = getWormVel(enemy);

	local curAim = getWormAim(self);

	local dx = ex - sx;
	local dy = ey - sy;

	local weapon = weapons[curWeap];

	local tx, ty = aimToVec(curAim);

	local vx = weaponData[weapon].initSpeed * tx;
	local vy = weaponData[weapon].initSpeed * ty;

	local affected = weaponData[weapon].affectedByWormMotion;
	local pLoop = weaponData[weapon].physicsLoop;

	if (affected ~= 0) then

		local tvx = (svx * affected) / pLoop;
		local tvy = (svy * affected) / pLoop;

		vx = vx + tvx;
		vy = vy + tvy;

	end

	local dist = math.sqrt(vx*vx + vy*vy) * pLoop;

	if (dist == 0) then
		dist = 1;
	end

	dist = math.sqrt(dx*dx + dy*dy) / dist;

	dx, dy = trace(ex, ey,  ex + evx * dist, ey + evy * dist, 3);

	return dx, dy;
end




function aiGetMove()

	local keys = { jump = 0; fire = 0; change = 0; left = 0; right = 0; up = 0; down = 0; };

	if (weapons[1] == 3) then

		enemy = 0;

	end

	if (enemy == nil) then

		local temp = math.random();
		local fire = 0;

		if (temp > 0.98) then
			direction = 1 - direction;
		end

		if (direction == 1) then
			keys.left = 1;
		else
			keys.right = 1;
		end
	else

		local sx, sy = getWormPos(self);
		local svx, svy = getWormVel(self);
		local ex, ey = getWormPos(enemy);
		local evx, evy = getWormVel(enemy);

		local curAim = getWormAim(self);
		local curDir = getWormDir(self);

		local dx, dy = getPointToAim();

		local bestWeap = getBestWeap(false);

		cx, cy = trace(sx, sy, dx, dy, 1);

		local angle = aim(sx, sy, dx, dy);

		if ((dx + 10 < sx) or ((dx < sx) and (curDir ~= 1))) then
			keys.left = 1;
		elseif ((dx - 10 > sx) or ((dx > sx) and (curDir ~= 0))) then
			keys.right = 1;
		end

		if (curAim < angle) then
			keys.up = 1;
		elseif (curAim > angle) then
			keys.down = 1;
		else
			if (cx == dx) and (cy == dy) then
				keys.fire = 1;
			end
		end

		if (math.random() > 0.9) then
			keys.change = 1;
		end

	end

	local value = 0;

	if (keys.jump ~= 0) then value = value + gamekeys.jump; end;
	if (keys.fire ~= 0) then value = value + gamekeys.fire; end;
	if (keys.change ~= 0) then value = value + gamekeys.change; end;
	if (keys.left ~= 0) then value = value + gamekeys.left; end;
	if (keys.right ~= 0) then value = value + gamekeys.right; end;
	if (keys.up ~= 0) then value = value + gamekeys.up; end;
	if (keys.down ~= 0) then value = value + gamekeys.down; end;

	return value;
end
